package dk.topsecurity;

import java.security.Principal;

/**
 * <p> TopsecurityPrincipal class implements the 
 * java.security.Principal interface and represents a user, who is
 * successfully authenticated in the LoginModule..
 *
 * <p> Principals such as this <code>TopsecurityPrincipal</code>
 * may be associated with a particular <code>Subject</code>
 * to augment that <code>Subject</code> with an additional
 * identity. Authorization decisions can then be based upon 
 * the Principals associated with a <code>Subject</code>.
 * 
 * @see java.security.Principal
 * @see javax.security.auth.Subject
 */
public class TopsecurityPrincipal implements Principal, java.io.Serializable {

    /**
     * Debug Flag
     */
    private static boolean DEBUG;
    
    /**
     * The name of the principal
     */
    private String name;

    /**
     * Create TopsecurityPrincipal representing user with username provided.<p>
     *
     * @param name the username for this user.
     * @exception NullPointerException if the <code>name</code> is <code>null</code>.
     */
    public TopsecurityPrincipal( String name ) {
	if( name == null )
	    throw new NullPointerException( "illegal null input" );
	
	this.name = name;
	if( DEBUG ) System.out.println( "\t[TopsecurityPrincipal] Principal " +
			 name + " successfully created." );
    }//end TopsecurityPrincipal( String )

    /**
     * Returns username for this <code>TopsecurityPrincipal</code>.<p>
     *
     * @return the username for this <code>TopsecurityPrincipal</code>
     */
    public String getName() {
		return name;
    }//end getName()

    /**
     * Toggles debug status on or off.<p>
     * 
     * @param debug flag to set the debug status
     */
    public static void setDebug( boolean debug ) {
		DEBUG = debug;	
    }//end setDebug( boolean )
	
    /**
     * Return a string representation of this <code>TopsecurityPrincipal</code>.<p>
     *
     * @return a string representation of this <code>TopsecurityPrincipal</code>.
     */
    public String toString() {
	return( "TopsecurityPrincipal:  " + name );
    }//end toString()

    /**
     * Compares the specified Object with this <code>TopsecurityPrincipal</code>.
     * True if the given object is also a <code>TopsecurityPrincipal</code> 
     * with the same username.<p>
     *
     * @param o Object to be compared for equality with .this
     * @return true if the specified Object is equal equal to .this
     */
    public boolean equals( Object o ) {
	if( o == null )
	    return false;
	if( this == o )
	    return true;
	 
	if( !(o instanceof TopsecurityPrincipal) )
	    return false;
	TopsecurityPrincipal that = (TopsecurityPrincipal)o;
	
	if( this.getName().equals(that.getName()) )
	    return true;
	return false;
    }//end equals()
 
    /**
     * Return a hash code for this <code>TopsecurityPrincipal</code>.<p>
     *
     * @return a hash code for this <code>TopsecurityPrincipal</code>.
     */
    public int hashCode() {
	return name.hashCode();
    }//end hashCode()
}//end class TopsecurityPrincipal