package dk.topsecurity;

import java.io.*;
import java.util.*;
import java.security.*;
import javax.security.auth.login.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.spi.*;

/**
 * <p> This demonstrates use of the JAAS API, by attempting to
 * authenticate and then authorize a user. Results of the security 
 * check are then printed out on the commandline.
 * </p>
 */

public class TopsecurityClientAuthorization {

/**
 * Interacts with user via commandline and attempts to
 * authenticate the user and authorize them to perform
 * a priveleged action.<p>
 * 
 * @param args Commandline input arguments (there are none).
 */
	public static void main(String[] args) {

		LoginContext logctx = null;
		
//1ST PART - ONLY ASSOCIATED WITH AUTHENTICATION
	try {
/* Constructor for LoginContext is intialized with a string containing
 * classname for the LoginModule implementation as specified in the JAAS 
 * login configuration file. Second parameter is an object of type 
 * CallbackHandler, which will actually handle the authentication attempts.
 */
    		logctx = new LoginContext( "TopsecurityJAASModule", new TopsecurityCallbackHandler());
	} catch( LoginException le ) {
		System.err.println("\t[TopsecurityClient] LoginContext creation failed. "+ le.getMessage());
    		System.exit( -1 );
	} catch( SecurityException se ) {
		System.err.println("\t[TopsecurityClient] LoginContext creation failed. "+ se.getMessage());
    		System.exit(-1);
	}//end try/catch 

	try {
		logctx.login(); // Attempts to authenticate user and succeesfull if no exception is thrown
		System.out.println("\t[TopsecurityClient] Authentication succeeded.");
	} catch( LoginException le ) {
		System.err.println("\t[TopsecurityClient] Authentication failed. " + le.getMessage());
		System.exit( -1 );
	}//end try/catch


//2ND PART - ONLY ASSOCIATED WITH AUTHORISATION
	try {
		Subject subj = logctx.getSubject();			// Extract the Subject
		TopsecurityPrincipal.setDebug( false );			// not interested in what Principal is created
		PrivilegedAction action = new TopsecurityAction();	// Try executing TopsecurityAction as the authenticated Subject
		Subject.doAsPrivileged( subj, action, null );		//Go!
	    	System.out.println( "\t[TopsecurityClient] Authorization succeeded\n");

//3RD PART - DOING A GRACEFULL LOGOUT

		try {
			logctx.logout();
		} catch(LoginException le) {
			System.err.println("\t[TopsecurityClient] Logout: " + le.getMessage());
		}
 	} catch( Exception ex ) {
    		System.err.println("\t[TopsecurityClient] Authorization failed: " + ex.getMessage() + "\n" );
	}//end try/catch
    }//end main()
}//end main class