package dk.topsecurity;

import java.io.*;
import java.util.*;
import javax.security.auth.login.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;

/**
 * <p>This class implements the CallbackHandler so that it can handle the JAAS
 * login callback methods.</p>
 *
 */
class TopsecurityCallbackHandler implements CallbackHandler {

    /**
     * Processes an array of callbacks to handle the login process.<p>
     *
     * @param callbacks an array of <code>Callback</code> objects containing
     *			the information requested by an underlying security
     *			service to be retrieved or displayed.
     * @exception java.io.IOException if an input or output error occurs. <p>
     * @exception UnsupportedCallbackException if the implementation of this
     *			method does not support one or more of the Callbacks
     *			specified in the <code>callbacks</code> parameter.
     * 
     * </p>
     */
    
    public void handle( Callback[] callbacks )
    	throws IOException, UnsupportedCallbackException {
      
	for( int i = 0; i < callbacks.length; i++ ) {
		if( callbacks[i] instanceof NameCallback ) {
	 		NameCallback nc = (NameCallback)callbacks[i]; 
	 		System.err.print( nc.getPrompt() ); // prompt the user for a username
	 		System.err.flush();
	 		nc.setName( (new BufferedReader
				(new InputStreamReader(System.in))).readLine() );
 	    	} else if( callbacks[i] instanceof PasswordCallback ) {
	 		PasswordCallback pc = (PasswordCallback)callbacks[i]; 
	 		System.err.print(pc.getPrompt()); // prompt the user for sensitive information
	 		System.err.flush();
			String pw = (new BufferedReader
				(new InputStreamReader(System.in))).readLine();
			char[] passwd = new char[pw.length()];
			    pw.getChars(0, passwd.length, passwd, 0);
	 		pc.setPassword( passwd );
 	    	} else {
 			throw new UnsupportedCallbackException
 				( callbacks[i], "Unrecognized Callback" );
 	    }//end if/else
	}//end for()
    }//handle()
}//end class TopsecurityCallbackHandler