/*
 * Decompiled with CFR 0.152.
 */
package dk.topsecurity;

import dk.topsecurity.TopsecurityPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class TopsecurityLoginModule
implements LoginModule {
    private boolean debug = false;
    private Subject subject;
    private TopsecurityPrincipal entity;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private static final int NOT = 0;
    private static final int OK = 1;
    private static final int COMMIT = 2;
    private int status;
    private static final String[] userNames = new String[]{"guest", "user1", "user2"};
    private static final String[] passwords = new String[]{"guest", "pass1", "pass2"};
    private String username;
    private char[] password;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.status = 0;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        TopsecurityPrincipal.setDebug("true".equalsIgnoreCase((String)map2.get("debug")));
    }

    private void debugOut(String string) {
        if (this.debug) {
            System.out.println("\t[TopsecurityLoginModule] " + string);
        }
    }

    public boolean login() throws LoginException {
        Object object;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to retrieve user credentials");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("\nuser name: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            object = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object == null) {
                object = new char[]{};
            }
            this.password = new char[((char[])object).length];
            System.arraycopy(object, 0, this.password, 0, ((char[])object).length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to authenticate user.");
        }
        object = new String(this.password);
        this.debugOut("user entered user name: " + this.username);
        this.debugOut("user entered password: " + (String)object + "\n");
        int n = 0;
        while (n < userNames.length) {
            if (this.username.equals(userNames[n]) && object.equals(passwords[n])) {
                this.debugOut("User #" + n + " authentication succeeded.");
                this.status = 1;
                return true;
            }
            this.debugOut("User #" + n + " authentication failed.");
            ++n;
        }
        return false;
    }

    public boolean commit() throws LoginException {
        if (this.status == 0 || this.subject == null) {
            return false;
        }
        this.entity = new TopsecurityPrincipal(this.username);
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.entity)) {
            set.add(this.entity);
        }
        this.debugOut("added TopsecurityPrincipal to Subject");
        this.username = null;
        this.password = null;
        this.status = 2;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.status == 0) {
            return false;
        }
        if (this.status == 1) {
            this.username = null;
            if (this.password != null) {
                this.password = null;
            }
            this.entity = null;
        } else {
            this.logout();
        }
        this.status = 0;
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.entity);
        this.status = 0;
        this.username = null;
        if (this.password != null) {
            this.password = null;
        }
        this.entity = null;
        return true;
    }
}

