/*
 * Decompiled with CFR 0.152.
 */
package dk.topsecurity;

import dk.topsecurity.TopsecurityAction;
import dk.topsecurity.TopsecurityCallbackHandler;
import dk.topsecurity.TopsecurityPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class TopsecurityClientAuthorization {
    public static void main(String[] stringArray) {
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext("TopsecurityJAASModule", (CallbackHandler)new TopsecurityCallbackHandler());
        }
        catch (LoginException loginException) {
            System.err.println("\t[TopsecurityClient] LoginContext creation failed. " + loginException.getMessage());
            System.exit(-1);
        }
        catch (SecurityException securityException) {
            System.err.println("\t[TopsecurityClient] LoginContext creation failed. " + securityException.getMessage());
            System.exit(-1);
        }
        try {
            loginContext.login();
            System.out.println("\t[TopsecurityClient] Authentication succeeded.");
        }
        catch (LoginException loginException) {
            System.err.println("\t[TopsecurityClient] Authentication failed. " + loginException.getMessage());
            System.exit(-1);
        }
        try {
            Subject subject = loginContext.getSubject();
            TopsecurityPrincipal.setDebug((boolean)false);
            TopsecurityAction topsecurityAction = new TopsecurityAction();
            Subject.doAsPrivileged(subject, topsecurityAction, null);
            System.out.println("\t[TopsecurityClient] Authorization succeeded\n");
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                System.err.println("\t[TopsecurityClient] Logout: " + loginException.getMessage());
            }
        }
        catch (Exception exception) {
            System.err.println("\t[TopsecurityClient] Authorization failed: " + exception.getMessage() + "\n");
        }
    }
}

