package dk.topsecurity;

import java.security.Principal;

/**
 * <p> TopsecurityPrincipal class implements the 
 * java.security.Principal interface and represents a user, who is
 * successfully authenticated in the LoginModule..
 *
 * <p> Principals such as this <code>TopsecurityPrincipal</code>
 * may be associated with a particular <code>Subject</code>
 * to augment that <code>Subject</code> with an additional
 * identity. Authorization decisions can then be based upon 
 * the Principals associated with a <code>Subject</code>.
 * 
 * @see java.security.Principal
 * @see javax.security.auth.Subject
 */
public class TopsecurityPrincipal implements Principal {
  private final String name;

  /**
   * Create TopsecurityPrincipal representing user with username provided.<p>
   *
   * @param name the username for this user.
   * @exception NullPointerException if the <code>name</code> is <code>null</code>.
   */
  public TopsecurityPrincipal(String name) {
    if(name == null) {
      throw new IllegalArgumentException("Null name");
    }
    this.name = name;
  }

  /**
   * Returns username for this <code>TopsecurityPrincipal</code>.<p>
   *
   * @return the username for this <code>TopsecurityPrincipal</code>
   */
  public String getName() {
    return name;
  }

  /**
   * Return a string representation of this <code>TopsecurityPrincipal</code>.<p>
   *
   * @return a string representation of this <code>TopsecurityPrincipal</code>.
   */
  public String toString() {
    return "TopsecurityPrincipal: "+name;
  }

  /**
   * Compares the specified Object with this <code>TopsecurityPrincipal</code>.
   * True if the given object is also a <code>TopsecurityPrincipal</code> 
   * with the same username.<p>
   *
   * @param o Object to be compared for equality with .this
   * @return true if the specified Object is equal equal to .this
   */
  public boolean equals(Object obj) {
    if(obj == null) return false;
    if(obj == this) return true;
    if(!(obj instanceof TopsecurityPrincipal)) return false;
    TopsecurityPrincipal another = (TopsecurityPrincipal) obj;
    return name.equals(another.getName());
  }

  /**
   * Return a hash code for this <code>TopsecurityPrincipal</code>.<p>
   *
   * @return a hash code for this <code>TopsecurityPrincipal</code>.
   */
  public int hasCode() {
    return name.hashCode();
  }
}

