package dk.topsecurity;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

/**
 * <p> Application demonstrates use of the JAAS API, by attempting to 
 * authenticate a user. Results of the authentication attempt are printed to 
 * the commandline.</p>
 */
public class TopsecurityClient {

/**
 * Interacts with user via commandline and attempts to authenticate the user.<p>
 * 
 * @param args Commandline input arguments (there are none).
 */
  public static void main(String argv[]) {
    LoginContext logctx = null;
    try {
/* Constructor for LoginContext is intialized with a string containing
 * classname for the LoginModule implementation as specified in the JAAS 
 * login configuration file. Second parameter is an object of type 
 * CallbackHandler, which will actually handle the authentication attempts.
 */
      logctx = new LoginContext("TopsecurityJAASModule", new TopsecurityCallbackHandler());
    } catch(LoginException le) {
      System.err.println("\t[TopsecurityClient] LoginContext creation failed. "+ le.getMessage());
      System.exit(-1);
    } catch(SecurityException se) {
      System.err.println("\t[TopsecurityClient] LoginContext creation failed. "+ se.getMessage());
    }

    try {
      logctx.login();
      System.out.println("\t[TopsecurityClient] Authentication succeeded.");
    } catch(LoginException le) {
     System.err.println("\t[TopsecurityClient] Authentication failed. " + le.getMessage());
     System.exit(-1);
    }
    System.exit(-1);
  }
}
