/*
 * Decompiled with CFR 0.152.
 */
package dk.topsecurity;

import dk.topsecurity.TopsecurityPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class TopsecurityLoginModule
implements LoginModule {
    private Subject subject;
    private TopsecurityPrincipal entity;
    private CallbackHandler callbackhandler;
    private static final int NOT = 0;
    private static final int OK = 1;
    private static final int COMMIT = 2;
    private int status;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.status = 0;
        this.entity = null;
        this.subject = subject;
        this.callbackhandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        if (this.callbackhandler == null) {
            throw new LoginException("Error: no CallbackHandler available to retrieve user credentials");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Tell me your credential?")};
        String string = null;
        try {
            this.callbackhandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString());
        }
        if (string.equals("Topsecurity")) {
            this.entity = new TopsecurityPrincipal(string);
            this.status = 1;
            return true;
        }
        return false;
    }

    public boolean commit() throws LoginException {
        if (this.status == 0 || this.subject == null) {
            return false;
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.entity)) {
            set.add(this.entity);
        }
        this.status = 2;
        return true;
    }

    public boolean abort() throws LoginException {
        Set<Principal> set;
        if (this.subject != null && this.entity != null && (set = this.subject.getPrincipals()).contains(this.entity)) {
            set.remove(this.entity);
        }
        this.subject = null;
        this.entity = null;
        this.status = 0;
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.entity);
        this.status = 0;
        this.subject = null;
        return true;
    }
}

