package dk.topsecurity;

import java.io.*;
import java.lang.*;
import com.sshtools.j2ssh.*;
import com.sshtools.j2ssh.authentication.*;

//Code by courtesy of :
//http://www.topsecurity.dk
//

public class SFtpResumeFile {

public static void main(String[] argv) {

  String host = "127.0.0.1", userName="guest01", password="guest01", filePathRemote="/readme.1st", filePathLocal="readme.1st.local";
  int port = 22;

  try {

    SshClient ssh = new SshClient();
    ssh.connect(host, port);

    System.out.println("Authenticate");

    PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
    passwordAuthenticationClient.setUsername(userName);
    passwordAuthenticationClient.setPassword(password);
    int result = ssh.authenticate(passwordAuthenticationClient);
    if(result != AuthenticationProtocolState.COMPLETE){
       throw new Exception("Login to " + host + ":" + port + " " + userName + "/" + password + " failed");
    }

    System.out.println("Open the SFTP channel");

    SftpClient client = ssh.openSftpClient();

    System.out.println("Auto-resume the file from last position (creating from new if necessary)");

    client.resume(filePathRemote,filePathLocal);

    System.out.println("disconnect");

    client.quit();
    ssh.disconnect();
  }
  catch(IOException iox) {
    iox.printStackTrace();
  }
  catch(Exception ex) {
    ex.printStackTrace();
  }

}




}